local assets =
{
	Asset("ANIM", "anim/dark_sword.zip"),
	Asset("ANIM", "anim/dark_sword_swap.zip"),
	
}

local function onfinished(inst)
    inst:Remove()
end

local function OnAttack(inst, attacker, target)	
	if attacker and attacker.components.sanity then
		attacker.components.sanity:DoDelta(-5)
	end
end

local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "dark_sword_swap", "dark_sword_swap")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
end

local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
end



local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    
     anim:SetBank("dark_sword")
    anim:SetBuild("dark_sword")
    anim:PlayAnimation("idle")
    
    inst:AddTag("sharp")

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(170)
	inst.components.weapon:SetRange(0.2, 0.2)
	inst.components.weapon:SetOnAttack(OnAttack)
    
    -------
    
    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(200)
    inst.components.finiteuses:SetUses(200)
    inst.components.finiteuses:SetOnFinished( onfinished )

    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/dark_sword.xml"
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
    
    return inst
end



return Prefab( "common/inventory/dark_sword", fn, assets) 